# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdproperty import *
from .sdnode import *
from .sdapiobject import *
from .sdproperty import *
from .sdproperty import *
from .sdapiobject import *
from .apiexception import APIException

class SDConnection(SDAPIObject):
    """
    The class that contains information about a connection between an output property of a node to an input property of another node
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDConnection
        """
        super(SDConnection, self).__init__(APIContext, handle, *args, **kwargs)

    def getOutputProperty(self) -> Optional[SDProperty]:
        """
        Get the output property of the node

        """
        outSDProperty = ctypes.c_void_p()
        _res = self.mAPIContext.SDConnection_getOutputProperty(self.mHandle, ctypes.byref(outSDProperty))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDProperty, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDProperty.value, ownHandle=True)

    def getOutputPropertyNode(self) -> Optional[SDNode]:
        """
        Get the node that own the output property

        """
        outSDNode = ctypes.c_void_p()
        _res = self.mAPIContext.SDConnection_getOutputPropertyNode(self.mHandle, ctypes.byref(outSDNode))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDNode, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDNode.value, ownHandle=True)

    def getInputProperty(self) -> Optional[SDProperty]:
        """
        Get the input property of the connected node

        """
        outSDProperty = ctypes.c_void_p()
        _res = self.mAPIContext.SDConnection_getInputProperty(self.mHandle, ctypes.byref(outSDProperty))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDProperty, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDProperty.value, ownHandle=True)

    def getInputPropertyNode(self) -> Optional[SDNode]:
        """
        Get the node that own the input property

        """
        outSDNode = ctypes.c_void_p()
        _res = self.mAPIContext.SDConnection_getInputPropertyNode(self.mHandle, ctypes.byref(outSDNode))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDNode, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDNode.value, ownHandle=True)

    def disconnect(self) -> None:
        """
        Disconnect the current connection

        """
        _res = self.mAPIContext.SDConnection_disconnect(self.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

